/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class WrappedPlainView
extends BoxView
implements TabExpander {
    Color selectedColor;
    Color unselectedColor;
    Color disabledColor;
    FontMetrics metrics;
    boolean wordWrap;
    ViewFactory viewFactory = new WrappedLineCreator();
    int selectionStart;
    int selectionEnd;
    int lineHeight;
    private int tabBase;
    private int tabSize;
    private transient Segment lineBuffer;

    public WrappedPlainView(Element elem) {
        this(elem, false);
    }

    public WrappedPlainView(Element elem, boolean wordWrap) {
        super(elem, 1);
        this.wordWrap = wordWrap;
    }

    protected final Segment getLineBuffer() {
        if (this.lineBuffer == null) {
            this.lineBuffer = new Segment();
        }
        return this.lineBuffer;
    }

    public float nextTabStop(float x, int tabStop) {
        int next = (int)x;
        if (this.tabSize != 0) {
            int numTabs = ((int)x - this.tabBase) / this.tabSize;
            next = this.tabBase + (numTabs + 1) * this.tabSize;
        }
        return next;
    }

    protected int getTabSize() {
        Object tabSize = this.getDocument().getProperty("tabSize");
        if (tabSize == null) {
            return 8;
        }
        return (Integer)tabSize;
    }

    protected void drawLine(int p0, int p1, Graphics g, int x, int y) {
        try {
            if (this.selectionStart == this.selectionEnd || p0 > this.selectionEnd || p1 < this.selectionStart) {
                this.drawUnselectedText(g, x, y, p0, p1);
            } else if (p0 >= this.selectionStart && p1 <= this.selectionEnd) {
                this.drawSelectedText(g, x, y, p0, p1);
            } else if (p0 >= this.selectionStart) {
                x = this.drawSelectedText(g, x, y, p0, this.selectionEnd);
                this.drawUnselectedText(g, x, y, this.selectionEnd, p1);
            } else if (this.selectionStart > p0 && this.selectionEnd > p1) {
                x = this.drawUnselectedText(g, x, y, p0, this.selectionStart);
                this.drawSelectedText(g, x, y, this.selectionStart, p1);
            } else if (this.selectionStart > p0) {
                x = this.drawUnselectedText(g, x, y, p0, this.selectionStart);
                x = this.drawSelectedText(g, x, y, this.selectionStart, this.selectionEnd);
                this.drawUnselectedText(g, x, y, this.selectionEnd, p1);
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    protected int drawSelectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
        g.setColor(this.selectedColor);
        Segment segment = this.getLineBuffer();
        this.getDocument().getText(p0, p1 - p0, segment);
        return Utilities.drawTabbedText(segment, x, y, g, this, p0);
    }

    protected int drawUnselectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
        JTextComponent textComponent = (JTextComponent)this.getContainer();
        if (textComponent.isEnabled()) {
            g.setColor(this.unselectedColor);
        } else {
            g.setColor(this.disabledColor);
        }
        Segment segment = this.getLineBuffer();
        this.getDocument().getText(p0, p1 - p0, segment);
        return Utilities.drawTabbedText(segment, x, y, g, this, p0);
    }

    protected void loadChildren(ViewFactory f) {
        Element root = this.getElement();
        int numChildren = root.getElementCount();
        if (numChildren == 0) {
            return;
        }
        View[] children = new View[numChildren];
        int i = 0;
        while (i < numChildren) {
            children[i] = new WrappedLine(root.getElement(i));
            ++i;
        }
        this.replace(0, 0, children);
    }

    protected int calculateBreakPosition(int p0, int p1) {
        Segment s;
        block2: {
            s = new Segment();
            try {
                this.getDocument().getText(p0, p1 - p0, s);
            }
            catch (BadLocationException badLocationException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)"Couldn't load text");
            }
        }
        int width = this.getWidth();
        int pos = this.wordWrap ? p0 + Utilities.getBreakLocation(s, this.metrics, this.tabBase, this.tabBase + width, this, p0) : p0 + Utilities.getTabbedTextOffset(s, this.metrics, this.tabBase, this.tabBase + width, this, p0, false);
        return pos;
    }

    void updateMetrics() {
        Container component = this.getContainer();
        this.metrics = component.getFontMetrics(component.getFont());
        this.tabSize = this.getTabSize() * this.metrics.charWidth('m');
    }

    public float getPreferredSpan(int axis) {
        this.updateMetrics();
        return super.getPreferredSpan(axis);
    }

    public float getMinimumSpan(int axis) {
        this.updateMetrics();
        return super.getMinimumSpan(axis);
    }

    public float getMaximumSpan(int axis) {
        this.updateMetrics();
        return super.getMaximumSpan(axis);
    }

    public void insertUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        this.updateChildren(e, a);
        Rectangle r = a != null && this.isAllocationValid() ? this.getInsideAllocation(a) : null;
        View v = this.getViewAtPosition(e.getOffset(), r);
        if (v != null) {
            v.insertUpdate(e, r, f);
        }
    }

    public void removeUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        this.updateChildren(e, a);
        Rectangle r = a != null && this.isAllocationValid() ? this.getInsideAllocation(a) : null;
        View v = this.getViewAtPosition(e.getOffset(), r);
        if (v != null) {
            v.removeUpdate(e, r, f);
        }
    }

    public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        this.updateChildren(e, a);
    }

    private void updateChildren(DocumentEvent ev, Shape a) {
        Element el = this.getElement();
        DocumentEvent.ElementChange ec = ev.getChange(el);
        if (ec != null) {
            Element[] removed = ec.getChildrenRemoved();
            Element[] added = ec.getChildrenAdded();
            View[] addedViews = new View[added.length];
            int i = 0;
            while (i < added.length) {
                addedViews[i] = new WrappedLine(added[i]);
                ++i;
            }
            this.replace(ec.getIndex(), removed.length, addedViews);
            if (a != null) {
                this.preferenceChanged(null, true, true);
                this.getContainer().repaint();
            }
        }
        this.updateMetrics();
    }

    public void paint(Graphics g, Shape a) {
        Rectangle r = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
        this.tabBase = r.x;
        JTextComponent comp = (JTextComponent)this.getContainer();
        this.updateMetrics();
        this.selectionStart = comp.getSelectionStart();
        this.selectionEnd = comp.getSelectionEnd();
        this.selectedColor = comp.getSelectedTextColor();
        this.unselectedColor = comp.getForeground();
        this.disabledColor = comp.getDisabledTextColor();
        this.selectedColor = comp.getSelectedTextColor();
        this.lineHeight = this.metrics.getHeight();
        g.setFont(comp.getFont());
        super.paint(g, a);
    }

    public void setSize(float width, float height) {
        this.updateMetrics();
        if (width != (float)this.getWidth()) {
            this.preferenceChanged(null, true, true);
        }
        super.setSize(width, height);
    }

    class WrappedLine
    extends View {
        int numLines;

        public WrappedLine(Element elem) {
            super(elem);
            this.numLines = 1;
        }

        public void paint(Graphics g, Shape s) {
            Highlighter h;
            Rectangle rect = s.getBounds();
            int end = this.getEndOffset();
            int currStart = this.getStartOffset();
            int count = 0;
            Container c = this.getContainer();
            LayeredHighlighter lh = null;
            JTextComponent tc = null;
            if (c instanceof JTextComponent && (h = (tc = (JTextComponent)c).getHighlighter()) instanceof LayeredHighlighter) {
                lh = (LayeredHighlighter)h;
            }
            while (currStart < end) {
                int currEnd = WrappedPlainView.this.calculateBreakPosition(currStart, end);
                if (lh != null) {
                    if (currEnd == end) {
                        lh.paintLayeredHighlights(g, currStart, currEnd - 1, s, tc, this);
                    } else {
                        lh.paintLayeredHighlights(g, currStart, currEnd, s, tc, this);
                    }
                }
                WrappedPlainView.this.drawLine(currStart, currEnd, g, rect.x, rect.y + WrappedPlainView.this.metrics.getAscent());
                rect.y += WrappedPlainView.this.lineHeight;
                currStart = currEnd == currStart ? ++currStart : currEnd;
                ++count;
            }
            if (count != this.numLines) {
                this.numLines = count;
                this.preferenceChanged(this, false, true);
            }
        }

        private int determineNumLines() {
            int nLines = 0;
            int end = this.getEndOffset();
            int i = this.getStartOffset();
            while (i < end) {
                ++nLines;
                int breakPoint = WrappedPlainView.this.calculateBreakPosition(i, end);
                i = breakPoint == i ? breakPoint + 1 : breakPoint;
            }
            return nLines;
        }

        public float getPreferredSpan(int axis) {
            if (axis == 0) {
                return WrappedPlainView.this.getWidth();
            }
            if (axis == 1) {
                if (WrappedPlainView.this.metrics == null) {
                    WrappedPlainView.this.updateMetrics();
                }
                return this.numLines * WrappedPlainView.this.metrics.getHeight();
            }
            throw new IllegalArgumentException("Invalid axis for getPreferredSpan: " + axis);
        }

        public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
            int lineHeight;
            Rectangle rect = a.getBounds();
            if (rect.isEmpty()) {
                throw new BadLocationException("Unable to calculate view coordinates when allocation area is empty.", pos);
            }
            Segment s = WrappedPlainView.this.getLineBuffer();
            rect.height = lineHeight = WrappedPlainView.this.metrics.getHeight();
            rect.width = 1;
            int currLineStart = this.getStartOffset();
            int end = this.getEndOffset();
            if (pos < currLineStart || pos >= end) {
                throw new BadLocationException("invalid offset", pos);
            }
            while (true) {
                int currLineEnd = WrappedPlainView.this.calculateBreakPosition(currLineStart, end);
                if (pos >= currLineStart && pos < currLineEnd) {
                    try {
                        this.getDocument().getText(currLineStart, pos - currLineStart, s);
                    }
                    catch (BadLocationException badLocationException) {}
                    rect.x += Utilities.getTabbedTextWidth(s, WrappedPlainView.this.metrics, rect.x, WrappedPlainView.this, currLineStart);
                    return rect;
                }
                rect.y += lineHeight;
                if (currLineEnd == currLineStart) {
                    currLineStart = end;
                    continue;
                }
                currLineStart = currLineEnd;
            }
        }

        /*
         * Unable to fully structure code
         */
        public int viewToModel(float x, float y, Shape a, Position.Bias[] b) {
            s = WrappedPlainView.this.getLineBuffer();
            rect = a.getBounds();
            currLineStart = this.getStartOffset();
            end = this.getEndOffset();
            lineHeight = WrappedPlainView.this.metrics.getHeight();
            if (y < (float)rect.y) {
                return currLineStart;
            }
            if (!(y > (float)(rect.y + rect.height))) ** GOTO lbl20
            return end - 1;
lbl-1000:
            // 1 sources

            {
                currLineEnd = WrappedPlainView.this.calculateBreakPosition(currLineStart, end);
                if (y >= (float)rect.y && y < (float)(rect.y + lineHeight)) {
                    try {
                        this.getDocument().getText(currLineStart, currLineEnd - currLineStart, s);
                    }
                    catch (BadLocationException v0) {}
                    offset = Utilities.getTabbedTextOffset(s, WrappedPlainView.this.metrics, rect.x, (int)x, WrappedPlainView.this, currLineStart);
                    return offset == currLineEnd ? offset - 1 : offset;
                }
                rect.y += lineHeight;
                currLineStart = currLineEnd;
lbl20:
                // 2 sources

                ** while (currLineStart != end)
            }
lbl21:
            // 1 sources

            return end;
        }

        void updateDamage(Rectangle a) {
            int nLines = this.determineNumLines();
            if (this.numLines != nLines) {
                this.numLines = nLines;
                this.preferenceChanged(this, false, true);
                this.getContainer().repaint();
            } else if (a != null) {
                this.getContainer().repaint(a.x, a.y, a.width, a.height);
            }
        }

        public void insertUpdate(DocumentEvent changes, Shape a, ViewFactory f) {
            Rectangle r = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
            this.updateDamage(r);
        }

        public void removeUpdate(DocumentEvent changes, Shape a, ViewFactory f) {
            Rectangle r = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
            this.updateDamage(r);
        }
    }

    class WrappedLineCreator
    implements ViewFactory {
        WrappedLineCreator() {
        }

        public View create(Element elem) {
            return new WrappedLine(elem);
        }
    }
}

