/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.SampleModel;
import java.util.Arrays;

public class ComponentSampleModel
extends SampleModel {
    protected int[] bandOffsets;
    protected int[] bankIndices;
    protected int numBands;
    protected int numBanks;
    protected int scanlineStride;
    protected int pixelStride;

    public ComponentSampleModel(int dataType, int w, int h, int pixelStride, int scanlineStride, int[] bandOffsets) {
        this(dataType, w, h, pixelStride, scanlineStride, new int[bandOffsets.length], bandOffsets);
    }

    public ComponentSampleModel(int dataType, int w, int h, int pixelStride, int scanlineStride, int[] bankIndices, int[] bandOffsets) {
        super(dataType, w, h, bandOffsets.length);
        if (dataType == 32) {
            throw new IllegalArgumentException("Unsupported dataType.");
        }
        if (pixelStride < 0 || scanlineStride < 0 || bandOffsets.length < 1 || bandOffsets.length != bankIndices.length) {
            throw new IllegalArgumentException();
        }
        this.bandOffsets = (int[])bandOffsets.clone();
        this.bankIndices = (int[])bankIndices.clone();
        this.numBands = bandOffsets.length;
        this.numBanks = 0;
        int b = 0;
        while (b < bankIndices.length) {
            this.numBanks = Math.max(this.numBanks, bankIndices[b] + 1);
            ++b;
        }
        this.scanlineStride = scanlineStride;
        this.pixelStride = pixelStride;
    }

    public SampleModel createCompatibleSampleModel(int w, int h) {
        return new ComponentSampleModel(this.dataType, w, h, this.pixelStride, this.scanlineStride, this.bankIndices, this.bandOffsets);
    }

    public SampleModel createSubsetSampleModel(int[] bands) {
        int numBands = bands.length;
        int[] bankIndices = new int[numBands];
        int[] bandOffsets = new int[numBands];
        int b = 0;
        while (b < numBands) {
            bankIndices[b] = this.bankIndices[bands[b]];
            bandOffsets[b] = this.bandOffsets[bands[b]];
            ++b;
        }
        return new ComponentSampleModel(this.dataType, this.width, this.height, this.pixelStride, this.scanlineStride, bankIndices, bandOffsets);
    }

    public DataBuffer createDataBuffer() {
        int highestOffset = 0;
        int b = 0;
        while (b < this.numBands) {
            highestOffset = Math.max(highestOffset, this.bandOffsets[b]);
            ++b;
        }
        int size = this.pixelStride * (this.width - 1) + this.scanlineStride * (this.height - 1) + highestOffset + 1;
        DataBuffer buffer = null;
        switch (this.getTransferType()) {
            case 0: {
                buffer = new DataBufferByte(size, this.numBanks);
                break;
            }
            case 2: {
                buffer = new DataBufferShort(size, this.numBanks);
                break;
            }
            case 1: {
                buffer = new DataBufferUShort(size, this.numBanks);
                break;
            }
            case 3: {
                buffer = new DataBufferInt(size, this.numBanks);
                break;
            }
            case 4: {
                buffer = new DataBufferFloat(size, this.numBanks);
                break;
            }
            case 5: {
                buffer = new DataBufferDouble(size, this.numBanks);
            }
        }
        return buffer;
    }

    public int getOffset(int x, int y) {
        return this.getOffset(x, y, 0);
    }

    public int getOffset(int x, int y, int b) {
        return this.bandOffsets[b] + this.pixelStride * x + this.scanlineStride * y;
    }

    public final int[] getSampleSize() {
        int size = DataBuffer.getDataTypeSize(this.getDataType());
        int[] sizes = new int[this.numBands];
        Arrays.fill(sizes, size);
        return sizes;
    }

    public final int getSampleSize(int band) {
        return DataBuffer.getDataTypeSize(this.getDataType());
    }

    public final int[] getBankIndices() {
        return (int[])this.bankIndices.clone();
    }

    public final int[] getBandOffsets() {
        return (int[])this.bandOffsets.clone();
    }

    public final int getScanlineStride() {
        return this.scanlineStride;
    }

    public final int getPixelStride() {
        return this.pixelStride;
    }

    public final int getNumDataElements() {
        return this.numBands;
    }

    public Object getDataElements(int x, int y, Object obj, DataBuffer data) {
        int type = this.getTransferType();
        int numDataEls = this.getNumDataElements();
        int offset = y * this.scanlineStride + x * this.pixelStride;
        switch (type) {
            case 0: {
                byte[] bData = obj == null ? new byte[numDataEls] : (byte[])obj;
                int i = 0;
                while (i < numDataEls) {
                    bData[i] = (byte)data.getElem(this.bankIndices[i], offset + this.bandOffsets[i]);
                    ++i;
                }
                obj = bData;
                break;
            }
            case 1: 
            case 2: {
                short[] sData = obj == null ? new short[numDataEls] : (short[])obj;
                int i = 0;
                while (i < numDataEls) {
                    sData[i] = (short)data.getElem(this.bankIndices[i], offset + this.bandOffsets[i]);
                    ++i;
                }
                obj = sData;
                break;
            }
            case 3: {
                int[] iData = obj == null ? new int[numDataEls] : (int[])obj;
                int i = 0;
                while (i < numDataEls) {
                    iData[i] = data.getElem(this.bankIndices[i], offset + this.bandOffsets[i]);
                    ++i;
                }
                obj = iData;
                break;
            }
            case 4: {
                float[] fData = obj == null ? new float[numDataEls] : (float[])obj;
                int i = 0;
                while (i < numDataEls) {
                    fData[i] = data.getElemFloat(this.bankIndices[i], offset + this.bandOffsets[i]);
                    ++i;
                }
                obj = fData;
                break;
            }
            case 5: {
                double[] dData = obj == null ? new double[numDataEls] : (double[])obj;
                int i = 0;
                while (i < numDataEls) {
                    dData[i] = data.getElemDouble(this.bankIndices[i], offset + this.bandOffsets[i]);
                    ++i;
                }
                obj = dData;
            }
        }
        return obj;
    }

    public int[] getPixel(int x, int y, int[] iArray, DataBuffer data) {
        if (x < 0 || x >= this.width || y < 0 || y >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Pixel (" + x + ", " + y + ") is out of bounds.");
        }
        int offset = this.pixelStride * x + this.scanlineStride * y;
        if (iArray == null) {
            iArray = new int[this.numBands];
        }
        int b = 0;
        while (b < this.numBands) {
            iArray[b] = data.getElem(this.bankIndices[b], offset + this.bandOffsets[b]);
            ++b;
        }
        return iArray;
    }

    public int[] getPixels(int x, int y, int w, int h, int[] iArray, DataBuffer data) {
        int offset = this.pixelStride * x + this.scanlineStride * y;
        if (iArray == null) {
            iArray = new int[this.numBands * w * h];
        }
        int outOffset = 0;
        y = 0;
        while (y < h) {
            int lineOffset = offset;
            x = 0;
            while (x < w) {
                int b = 0;
                while (b < this.numBands) {
                    iArray[outOffset++] = data.getElem(this.bankIndices[b], lineOffset + this.bandOffsets[b]);
                    ++b;
                }
                lineOffset += this.pixelStride;
                ++x;
            }
            offset += this.scanlineStride;
            ++y;
        }
        return iArray;
    }

    public int getSample(int x, int y, int b, DataBuffer data) {
        if (x < 0 || x >= this.width || y < 0 || y >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Sample (" + x + ", " + y + ") is out of bounds.");
        }
        return data.getElem(this.bankIndices[b], this.getOffset(x, y, b));
    }

    public void setDataElements(int x, int y, Object obj, DataBuffer data) {
        int type = this.getTransferType();
        int numDataEls = this.getNumDataElements();
        int offset = y * this.scanlineStride + x * this.pixelStride;
        switch (type) {
            case 0: {
                byte[] bData = (byte[])obj;
                int i = 0;
                while (i < numDataEls) {
                    data.setElem(this.bankIndices[i], offset + this.bandOffsets[i], bData[i] & 0xFF);
                    ++i;
                }
                break;
            }
            case 1: 
            case 2: {
                short[] sData = (short[])obj;
                int i = 0;
                while (i < numDataEls) {
                    data.setElem(this.bankIndices[i], offset + this.bandOffsets[i], sData[i] & 0xFFFF);
                    ++i;
                }
                break;
            }
            case 3: {
                int[] iData = (int[])obj;
                int i = 0;
                while (i < numDataEls) {
                    data.setElem(this.bankIndices[i], offset + this.bandOffsets[i], iData[i]);
                    ++i;
                }
                break;
            }
            case 4: {
                float[] fData = (float[])obj;
                int i = 0;
                while (i < numDataEls) {
                    data.setElemFloat(this.bankIndices[i], offset + this.bandOffsets[i], fData[i]);
                    ++i;
                }
                break;
            }
            case 5: {
                double[] dData = (double[])obj;
                int i = 0;
                while (i < numDataEls) {
                    data.setElemDouble(this.bankIndices[i], offset + this.bandOffsets[i], dData[i]);
                    ++i;
                }
                break;
            }
        }
    }

    public void setPixel(int x, int y, int[] iArray, DataBuffer data) {
        int offset = this.pixelStride * x + this.scanlineStride * y;
        int b = 0;
        while (b < this.numBands) {
            data.setElem(this.bankIndices[b], offset + this.bandOffsets[b], iArray[b]);
            ++b;
        }
    }

    public void setSample(int x, int y, int b, int s, DataBuffer data) {
        data.setElem(this.bankIndices[b], this.getOffset(x, y, b), s);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentSampleModel)) {
            return false;
        }
        ComponentSampleModel that = (ComponentSampleModel)obj;
        if (this.dataType != that.dataType) {
            return false;
        }
        if (this.width != that.width) {
            return false;
        }
        if (this.height != that.height) {
            return false;
        }
        if (this.pixelStride != that.pixelStride) {
            return false;
        }
        if (this.scanlineStride != that.scanlineStride) {
            return false;
        }
        if (!Arrays.equals(this.bandOffsets, that.bandOffsets)) {
            return false;
        }
        return Arrays.equals(this.bankIndices, that.bankIndices);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.dataType;
        result = 37 * result + this.width;
        result = 37 * result + this.height;
        result = 37 * result + this.pixelStride;
        result = 37 * result + this.scanlineStride;
        int i = 0;
        while (i < this.bandOffsets.length) {
            result = 37 * result + this.bandOffsets[i];
            ++i;
        }
        i = 0;
        while (i < this.bankIndices.length) {
            result = 37 * result + this.bankIndices[i];
            ++i;
        }
        return result;
    }
}

