/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.PropertyPermission;
import java.util.logging.Logger;

public final class Properties {
    private static final Logger log = Logger.getLogger(Properties.class.getName());
    public static final String VERSION = "gnu.crypto.version";
    public static final String PROPERTIES_FILE = "gnu.crypto.properties.file";
    public static final String REPRODUCIBLE_PRNG = "gnu.crypto.with.reproducible.prng";
    public static final String CHECK_WEAK_KEYS = "gnu.crypto.with.check.for.weak.keys";
    public static final String DO_RSA_BLINDING = "gnu.crypto.with.rsa.blinding";
    private static final String TRUE = Boolean.TRUE.toString();
    private static final String FALSE = Boolean.FALSE.toString();
    private static final HashMap props = new HashMap();
    private static Properties singleton = null;
    private boolean reproducible = false;
    private boolean checkForWeakKeys = true;
    private boolean doRSABlinding = true;

    private Properties() {
        this.init();
    }

    public static final synchronized String getProperty(String key) {
        if (key == null) {
            return null;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new PropertyPermission(key, "read"));
        }
        if ("".equals(key = key.trim().toLowerCase())) {
            return null;
        }
        return (String)props.get(key);
    }

    public static final synchronized void setProperty(String key, String value) {
        if (key == null || value == null) {
            return;
        }
        if ("".equals(key = key.trim().toLowerCase())) {
            return;
        }
        if (key.equals(VERSION)) {
            return;
        }
        if ("".equals(value = value.trim())) {
            return;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new PropertyPermission(key, "write"));
        }
        if (key.equals(REPRODUCIBLE_PRNG) && (value.equalsIgnoreCase(TRUE) || value.equalsIgnoreCase(FALSE))) {
            Properties.setReproducible(Boolean.valueOf(value));
        } else if (key.equals(CHECK_WEAK_KEYS) && (value.equalsIgnoreCase(TRUE) || value.equalsIgnoreCase(FALSE))) {
            Properties.setCheckForWeakKeys(Boolean.valueOf(value));
        } else if (key.equals(DO_RSA_BLINDING) && (value.equalsIgnoreCase(TRUE) || value.equalsIgnoreCase(FALSE))) {
            Properties.setDoRSABlinding(Boolean.valueOf(value));
        } else {
            props.put(key, value);
        }
    }

    public static final synchronized boolean isReproducible() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new PropertyPermission(REPRODUCIBLE_PRNG, "read"));
        }
        return Properties.instance().reproducible;
    }

    public static final synchronized boolean checkForWeakKeys() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new PropertyPermission(CHECK_WEAK_KEYS, "read"));
        }
        return Properties.instance().checkForWeakKeys;
    }

    public static final synchronized boolean doRSABlinding() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new PropertyPermission(DO_RSA_BLINDING, "read"));
        }
        return Properties.instance().doRSABlinding;
    }

    public static final synchronized void setReproducible(boolean value) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new PropertyPermission(REPRODUCIBLE_PRNG, "write"));
        }
        Properties.instance().reproducible = value;
        props.put(REPRODUCIBLE_PRNG, String.valueOf(value));
    }

    public static final synchronized void setCheckForWeakKeys(boolean value) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new PropertyPermission(CHECK_WEAK_KEYS, "write"));
        }
        Properties.instance().checkForWeakKeys = value;
        props.put(CHECK_WEAK_KEYS, String.valueOf(value));
    }

    public static final synchronized void setDoRSABlinding(boolean value) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new PropertyPermission(DO_RSA_BLINDING, "write"));
        }
        Properties.instance().doRSABlinding = value;
        props.put(DO_RSA_BLINDING, String.valueOf(value));
    }

    private static final synchronized Properties instance() {
        if (singleton == null) {
            singleton = new Properties();
        }
        return singleton;
    }

    private void init() {
        props.put(REPRODUCIBLE_PRNG, this.reproducible ? "true" : "false");
        props.put(CHECK_WEAK_KEYS, this.checkForWeakKeys ? "true" : "false");
        props.put(DO_RSA_BLINDING, this.doRSABlinding ? "true" : "false");
        String propFile = null;
        try {
            propFile = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty(Properties.PROPERTIES_FILE);
                }
            });
        }
        catch (SecurityException securityException) {}
        if (propFile != null) {
            try {
                java.util.Properties temp = new java.util.Properties();
                FileInputStream fin = new FileInputStream(propFile);
                temp.load(fin);
                temp.list(System.out);
                props.putAll(temp);
            }
            catch (IOException iOException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        this.handleBooleanProperty(REPRODUCIBLE_PRNG);
        this.handleBooleanProperty(CHECK_WEAK_KEYS);
        this.handleBooleanProperty(DO_RSA_BLINDING);
        this.reproducible = Boolean.valueOf((String)props.get(REPRODUCIBLE_PRNG));
        this.checkForWeakKeys = Boolean.valueOf((String)props.get(CHECK_WEAK_KEYS));
        this.doRSABlinding = Boolean.valueOf((String)props.get(DO_RSA_BLINDING));
        props.put(VERSION, "2.1.0");
    }

    private void handleBooleanProperty(String name) {
        String s = null;
        try {
            s = System.getProperty(name);
        }
        catch (SecurityException securityException) {}
        if (s != null && ((s = s.trim().toLowerCase()).equals(TRUE) || s.equals(FALSE))) {
            props.put(name, s);
        }
    }
}

