/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.CairoGraphics2D;
import gnu.java.awt.peer.gtk.CairoSurface;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.RenderedImage;
import java.util.Hashtable;

public class CairoSurfaceGraphics
extends CairoGraphics2D {
    protected CairoSurface surface;
    private BufferedImage buffer;
    private long cairo_t;

    public CairoSurfaceGraphics(CairoSurface surface) {
        this.surface = surface;
        this.cairo_t = surface.newCairoContext();
        this.setup(this.cairo_t);
        this.setClip(0, 0, surface.width, surface.height);
    }

    private CairoSurfaceGraphics(CairoSurfaceGraphics copyFrom) {
        this.surface = copyFrom.surface;
        this.cairo_t = this.surface.newCairoContext();
        this.copy(copyFrom, this.cairo_t);
    }

    public Graphics create() {
        return new CairoSurfaceGraphics(this);
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    protected Rectangle2D getRealBounds() {
        return new Rectangle2D.Double(0.0, 0.0, this.surface.width, this.surface.height);
    }

    public void copyAreaImpl(int x, int y, int width, int height, int dx, int dy) {
        this.surface.copyAreaNative(x, y, width, height, dx, dy, this.surface.width);
    }

    public void draw(Shape s) {
        if (!this.surface.sharedBuffer) {
            this.surface.syncJavaToNative(this.surface.surfacePointer, this.surface.getData());
        }
        Rectangle r = this.findStrokedBounds(s);
        if (this.shiftDrawCalls) {
            ++r.width;
            ++r.height;
        }
        if (this.comp == null || this.comp instanceof AlphaComposite) {
            super.draw(s);
        } else {
            this.createBuffer();
            Graphics2D g2d = (Graphics2D)this.buffer.getGraphics();
            g2d.setStroke(this.getStroke());
            g2d.setColor(this.getColor());
            g2d.setTransform(this.transform);
            g2d.draw(s);
            this.drawComposite(r.getBounds2D(), null);
        }
        if (!this.surface.sharedBuffer) {
            this.surface.syncNativeToJava(this.surface.surfacePointer, this.surface.getData());
        }
    }

    public void fill(Shape s) {
        if (!this.surface.sharedBuffer) {
            this.surface.syncJavaToNative(this.surface.surfacePointer, this.surface.getData());
        }
        if (this.comp == null || this.comp instanceof AlphaComposite) {
            super.fill(s);
        } else {
            this.createBuffer();
            Graphics2D g2d = (Graphics2D)this.buffer.getGraphics();
            g2d.setPaint(this.getPaint());
            g2d.setColor(this.getColor());
            g2d.setTransform(this.transform);
            g2d.fill(s);
            this.drawComposite(s.getBounds2D(), null);
        }
        if (!this.surface.sharedBuffer) {
            this.surface.syncNativeToJava(this.surface.surfacePointer, this.surface.getData());
        }
    }

    public void drawRenderedImage(RenderedImage image, AffineTransform xform) {
        if (!this.surface.sharedBuffer) {
            this.surface.syncJavaToNative(this.surface.surfacePointer, this.surface.getData());
        }
        if (this.comp == null || this.comp instanceof AlphaComposite) {
            super.drawRenderedImage(image, xform);
        } else {
            this.createBuffer();
            Graphics2D g2d = (Graphics2D)this.buffer.getGraphics();
            g2d.setRenderingHints(this.getRenderingHints());
            g2d.setTransform(this.transform);
            g2d.drawRenderedImage(image, xform);
            this.drawComposite(this.buffer.getRaster().getBounds(), null);
        }
        if (!this.surface.sharedBuffer) {
            this.surface.syncNativeToJava(this.surface.surfacePointer, this.surface.getData());
        }
    }

    protected boolean drawImage(Image img, AffineTransform xform, Color bgcolor, ImageObserver obs) {
        boolean ret;
        if (!this.surface.sharedBuffer) {
            this.surface.syncJavaToNative(this.surface.surfacePointer, this.surface.getData());
        }
        if (this.comp == null || this.comp instanceof AlphaComposite) {
            ret = super.drawImage(img, xform, bgcolor, obs);
        } else {
            if (!(img instanceof BufferedImage)) {
                ImageProducer source = img.getSource();
                if (source == null) {
                    return false;
                }
                img = Toolkit.getDefaultToolkit().createImage(source);
            }
            BufferedImage bImg = (BufferedImage)img;
            Rectangle2D bounds = new Rectangle(bImg.getMinX(), bImg.getMinY(), bImg.getWidth(), bImg.getHeight());
            if (xform != null) {
                bounds = CairoSurfaceGraphics.getTransformedBounds(bounds, xform);
            }
            this.createBuffer();
            Graphics2D g2d = (Graphics2D)this.buffer.getGraphics();
            g2d.setRenderingHints(this.getRenderingHints());
            g2d.drawImage(img, xform, obs);
            ret = this.drawComposite(bounds, obs);
        }
        if (!this.surface.sharedBuffer) {
            this.surface.syncNativeToJava(this.surface.surfacePointer, this.surface.getData());
        }
        return ret;
    }

    public void drawGlyphVector(GlyphVector gv, float x, float y) {
        if (!this.surface.sharedBuffer) {
            this.surface.syncJavaToNative(this.surface.surfacePointer, this.surface.getData());
        }
        if (this.comp == null || this.comp instanceof AlphaComposite) {
            super.drawGlyphVector(gv, x, y);
        } else {
            this.createBuffer();
            Graphics2D g2d = (Graphics2D)this.buffer.getGraphics();
            g2d.setPaint(this.getPaint());
            g2d.setStroke(this.getStroke());
            g2d.drawGlyphVector(gv, x, y);
            Rectangle2D bounds = gv.getLogicalBounds();
            bounds = new Rectangle2D.Double((double)x + bounds.getX(), (double)y + bounds.getY(), bounds.getWidth(), bounds.getHeight());
            this.drawComposite(bounds, null);
        }
        if (!this.surface.sharedBuffer) {
            this.surface.syncNativeToJava(this.surface.surfacePointer, this.surface.getData());
        }
    }

    private boolean drawComposite(Rectangle2D bounds, ImageObserver observer) {
        bounds = CairoSurfaceGraphics.getTransformedBounds(bounds, this.transform);
        Rectangle2D devClip = this.getClipInDevSpace();
        Rectangle2D.intersect(bounds, devClip, bounds);
        devClip = new Rectangle(this.buffer.getMinX(), this.buffer.getMinY(), this.buffer.getWidth(), this.buffer.getHeight());
        Rectangle2D.intersect(bounds, devClip, bounds);
        double x = bounds.getX();
        double y = bounds.getY();
        double maxX = x + bounds.getWidth();
        double maxY = y + bounds.getHeight();
        x = Math.round(x);
        y = Math.round(y);
        bounds.setRect(x, y, Math.round(maxX - x), Math.round(maxY - y));
        BufferedImage buffer2 = this.buffer;
        if (!bounds.equals(buffer2.getRaster().getBounds())) {
            buffer2 = buffer2.getSubimage((int)bounds.getX(), (int)bounds.getY(), (int)bounds.getWidth(), (int)bounds.getHeight());
        }
        BufferedImage current = CairoSurface.getBufferedImage(this.surface);
        current = current.getSubimage((int)bounds.getX(), (int)bounds.getY(), (int)bounds.getWidth(), (int)bounds.getHeight());
        this.compCtx.compose(buffer2.getRaster(), current.getRaster(), buffer2.getRaster());
        Composite oldcomp = this.comp;
        this.setComposite(AlphaComposite.Src);
        boolean rv = super.drawImage((Image)buffer2, AffineTransform.getTranslateInstance(bounds.getX(), bounds.getY()), null, null);
        this.setComposite(oldcomp);
        this.updateColor();
        return rv;
    }

    private void createBuffer() {
        if (this.buffer == null) {
            this.buffer = new BufferedImage(this.getBufferCM(), this.surface.createCompatibleWritableRaster(), this.getBufferCM().isAlphaPremultiplied(), new Hashtable());
        } else {
            Graphics2D g2d = (Graphics2D)this.buffer.getGraphics();
            g2d.setBackground(new Color(0, 0, 0, 0));
            g2d.clearRect(0, 0, this.buffer.getWidth(), this.buffer.getHeight());
        }
    }

    protected ColorModel getNativeCM() {
        return CairoSurface.cairoCM_pre;
    }

    protected ColorModel getBufferCM() {
        return CairoSurface.cairoColorModel;
    }
}

