/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.sasl.srp;

import gnu.java.security.prng.LimitReachedException;
import gnu.java.security.util.PRNG;
import gnu.javax.crypto.prng.UMacGenerator;
import java.util.HashMap;

public class KDF {
    private static final int AES_BLOCK_SIZE = 16;
    private static final int AES_KEY_SIZE = 16;
    private static final byte[] buffer = new byte[1];
    private static final PRNG prng = PRNG.getInstance();
    private UMacGenerator umac = null;

    private KDF(byte[] keyMaterial, int ndx) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("gnu.crypto.prng.umac.cipher.name", "aes");
        map.put("gnu.crypto.prng.umac.index", ndx);
        map.put("gnu.crypto.cipher.block.size", 16);
        byte[] key = new byte[16];
        System.arraycopy(keyMaterial, 0, key, 0, 16);
        map.put("gnu.crypto.cipher.key.material", key);
        this.umac = new UMacGenerator();
        this.umac.init(map);
    }

    static final KDF getInstance(byte[] K) {
        byte[] keyMaterial;
        int ndx = -1;
        if (K != null) {
            keyMaterial = K;
            ndx = 0;
        } else {
            keyMaterial = new byte[16];
            while (ndx < 1 || ndx > 255) {
                ndx = (byte)KDF.nextByte();
            }
        }
        return new KDF(keyMaterial, ndx);
    }

    private static final synchronized int nextByte() {
        prng.nextBytes(buffer);
        return buffer[0] & 0xFF;
    }

    public synchronized byte[] derive(int length) {
        byte[] result = new byte[length];
        try {
            this.umac.nextBytes(result, 0, length);
        }
        catch (IllegalStateException x) {
            x.printStackTrace(System.err);
        }
        catch (LimitReachedException x) {
            x.printStackTrace(System.err);
        }
        return result;
    }
}

