/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.kerberos;

import gnu.classpath.NotImplementedException;
import gnu.classpath.SystemProperties;
import java.io.Serializable;
import java.security.Principal;

public final class KerberosPrincipal
implements Serializable,
Principal {
    public static final int KRB_NT_PRINCIPAL = 1;
    public static final int KRB_NT_SRV_HST = 3;
    public static final int KRB_NT_SRV_INST = 2;
    public static final int KRB_NT_SRV_XHST = 4;
    public static final int KRB_NT_UID = 5;
    public static final int KRB_NT_UNKNOWN = 0;
    private String name;
    private int type;
    private String realm;

    public KerberosPrincipal(String name) {
        this(name, 1);
    }

    public KerberosPrincipal(String name, int type) throws NotImplementedException {
        if (type < 0 || type > 5) {
            throw new IllegalArgumentException("unknown type: " + type);
        }
        this.name = name;
        this.type = type;
        this.realm = this.parseRealm();
    }

    private String parseRealm() {
        int len = this.name.length();
        boolean quoted = false;
        int i = 0;
        while (i < len) {
            if (quoted) {
                quoted = false;
            } else {
                char c = this.name.charAt(i);
                if (c == '\\') {
                    quoted = true;
                } else if (c == '@') break;
            }
            ++i;
        }
        if (quoted || i == len - 1) {
            throw new IllegalArgumentException("malformed principal: " + this.name);
        }
        if (i < len) {
            return this.name.substring(i + 1);
        }
        String def = SystemProperties.getProperty("java.security.krb5.realm");
        if (def != null) {
            return def;
        }
        throw new IllegalArgumentException("default realm can't be found");
    }

    public String getName() {
        return this.name;
    }

    public String getRealm() {
        return this.realm;
    }

    public int getNameType() {
        return this.type;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof KerberosPrincipal)) {
            return false;
        }
        KerberosPrincipal kp = (KerberosPrincipal)other;
        return this.name.equals(kp.name) && this.type == kp.type;
    }

    public String toString() {
        return String.valueOf(this.name) + ":" + this.type;
    }
}

