/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import gnu.java.awt.ClasspathToolkit;
import java.awt.AWTPermission;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Toolkit;
import java.awt.peer.MouseInfoPeer;

public class MouseInfo {
    private static MouseInfoPeer peer;

    private MouseInfo() {
    }

    public static PointerInfo getPointerInfo() throws HeadlessException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AWTPermission("watchMousePointer"));
        }
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        if (peer == null) {
            peer = Toolkit.getDefaultToolkit().getMouseInfoPeer();
        }
        Point p = new Point();
        int screen = peer.fillPointWithCoords(p);
        GraphicsDevice[] gds = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        return new PointerInfo(gds[screen], p);
    }

    public static int getNumberOfButtons() throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        return ((ClasspathToolkit)Toolkit.getDefaultToolkit()).getMouseNumberOfButtons();
    }
}

