/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import java.nio.ByteBuffer;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;

public abstract class SSLEngine {
    private final String peerHost;
    private final int peerPort;

    protected SSLEngine() {
        this(null, -1);
    }

    protected SSLEngine(String peerHost, int peerPort) {
        this.peerHost = peerHost;
        this.peerPort = peerPort;
    }

    public abstract void beginHandshake() throws SSLException;

    public abstract void closeInbound() throws SSLException;

    public abstract void closeOutbound();

    public abstract Runnable getDelegatedTask();

    public String getPeerHost() {
        return this.peerHost;
    }

    public int getPeerPort() {
        return this.peerPort;
    }

    public abstract String[] getEnabledCipherSuites();

    public abstract String[] getEnabledProtocols();

    public abstract boolean getEnableSessionCreation();

    public abstract SSLEngineResult.HandshakeStatus getHandshakeStatus();

    public abstract boolean getNeedClientAuth();

    public abstract SSLSession getSession();

    public abstract String[] getSupportedCipherSuites();

    public abstract String[] getSupportedProtocols();

    public abstract boolean getUseClientMode();

    public abstract boolean getWantClientAuth();

    public abstract boolean isInboundDone();

    public abstract boolean isOutboundDone();

    public abstract void setEnabledCipherSuites(String[] var1);

    public abstract void setEnabledProtocols(String[] var1);

    public abstract void setEnableSessionCreation(boolean var1);

    public abstract void setUseClientMode(boolean var1);

    public abstract void setNeedClientAuth(boolean var1);

    public abstract void setWantClientAuth(boolean var1);

    public SSLEngineResult unwrap(ByteBuffer source, ByteBuffer sink) throws SSLException {
        return this.unwrap(source, new ByteBuffer[]{sink}, 0, 1);
    }

    public SSLEngineResult unwrap(ByteBuffer source, ByteBuffer[] sinks) throws SSLException {
        return this.unwrap(source, sinks, 0, sinks.length);
    }

    public abstract SSLEngineResult unwrap(ByteBuffer var1, ByteBuffer[] var2, int var3, int var4) throws SSLException;

    public SSLEngineResult wrap(ByteBuffer source, ByteBuffer sink) throws SSLException {
        return this.wrap(new ByteBuffer[]{source}, 0, 1, sink);
    }

    public SSLEngineResult wrap(ByteBuffer[] sources, ByteBuffer sink) throws SSLException {
        return this.wrap(sources, 0, sources.length, sink);
    }

    public abstract SSLEngineResult wrap(ByteBuffer[] var1, int var2, int var3, ByteBuffer var4) throws SSLException;
}

