/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import gnu.classpath.SystemProperties;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.ButtonModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicHTML;

public class BasicButtonListener
implements MouseListener,
MouseMotionListener,
FocusListener,
ChangeListener,
PropertyChangeListener {
    public BasicButtonListener(AbstractButton b) {
    }

    public void propertyChange(PropertyChangeEvent e) {
        String property = e.getPropertyName();
        AbstractButton b = (AbstractButton)e.getSource();
        if ((property.equals("text") || property.equals("font")) && SystemProperties.getProperty("gnu.javax.swing.noGraphics2D") == null) {
            String text = b.getText();
            if (text == null) {
                text = "";
            }
            FontRenderContext frc = new FontRenderContext(new AffineTransform(), false, false);
            TextLayout layout = new TextLayout(text, b.getFont(), frc);
            b.putClientProperty("BasicGraphicsUtils.cachedTextLayout", layout);
            BasicHTML.updateRenderer(b, b.getText());
        } else if (property.equals("contentAreaFilled")) {
            this.checkOpacity(b);
        }
    }

    protected void checkOpacity(AbstractButton b) {
        b.setOpaque(b.isContentAreaFilled());
    }

    public void focusGained(FocusEvent e) {
        AbstractButton button;
        if (e.getSource() instanceof AbstractButton && (button = (AbstractButton)e.getSource()).isFocusPainted()) {
            button.repaint();
        }
    }

    public void focusLost(FocusEvent e) {
        AbstractButton button;
        if (e.getSource() instanceof AbstractButton && (button = (AbstractButton)e.getSource()).isFocusPainted()) {
            button.repaint();
        }
    }

    public void installKeyboardActions(JComponent c) {
        ButtonUI ui = ((AbstractButton)c).getUI();
        if (ui instanceof BasicButtonUI) {
            BasicButtonUI basicUI = (BasicButtonUI)ui;
            String prefix = basicUI.getPropertyPrefix();
            InputMap focusInputMap = (InputMap)UIManager.get(String.valueOf(prefix) + "focusInputMap");
            SwingUtilities.replaceUIInputMap(c, 0, focusInputMap);
            ActionMap am = (ActionMap)UIManager.get(String.valueOf(prefix) + "actionMap");
            if (am == null) {
                am = this.createDefaultActionMap();
                UIManager.put(String.valueOf(prefix) + "actionMap", am);
            }
            SwingUtilities.replaceUIActionMap(c, am);
        }
        c.getActionMap().put("pressed", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                AbstractButton button = (AbstractButton)e.getSource();
                ButtonModel model = button.getModel();
                model.setArmed(true);
                model.setPressed(true);
            }
        });
        c.getActionMap().put("released", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                AbstractButton button = (AbstractButton)e.getSource();
                ButtonModel model = button.getModel();
                model.setPressed(false);
                model.setArmed(false);
            }
        });
    }

    private ActionMap createDefaultActionMap() {
        ButtonAction action = new ButtonAction();
        ActionMapUIResource am = new ActionMapUIResource();
        am.put("pressed", action);
        am.put("released", action);
        return am;
    }

    public void uninstallKeyboardActions(JComponent c) {
        SwingUtilities.replaceUIActionMap(c, null);
        SwingUtilities.replaceUIInputMap(c, 0, null);
    }

    public void stateChanged(ChangeEvent e) {
        ((AbstractButton)e.getSource()).repaint();
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (e.getSource() instanceof AbstractButton) {
            AbstractButton button = (AbstractButton)e.getSource();
            ButtonModel model = button.getModel();
            if (SwingUtilities.isLeftMouseButton(e)) {
                model.setArmed(true);
                model.setPressed(true);
                if (!button.isFocusOwner() && button.isRequestFocusEnabled()) {
                    button.requestFocus();
                }
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getSource() instanceof AbstractButton) {
            AbstractButton button = (AbstractButton)e.getSource();
            ButtonModel model = button.getModel();
            if (e.getButton() == 1) {
                model.setPressed(false);
                model.setArmed(false);
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
        if (e.getSource() instanceof AbstractButton) {
            AbstractButton button = (AbstractButton)e.getSource();
            ButtonModel model = button.getModel();
            if (button.isRolloverEnabled() && !SwingUtilities.isLeftMouseButton(e)) {
                model.setRollover(true);
            }
            if (model.isPressed()) {
                model.setArmed(true);
            }
        }
    }

    public void mouseExited(MouseEvent e) {
        if (e.getSource() instanceof AbstractButton) {
            AbstractButton button = (AbstractButton)e.getSource();
            ButtonModel model = button.getModel();
            if (button.isRolloverEnabled()) {
                model.setRollover(false);
            }
            model.setArmed(false);
        }
    }

    private class ButtonAction
    extends AbstractAction {
        static final String PRESSED = "pressed";
        static final String RELEASED = "released";

        private ButtonAction() {
        }

        public void actionPerformed(ActionEvent event) {
            Object cmd = this.getValue("__command__");
            AbstractButton b = (AbstractButton)event.getSource();
            ButtonModel m = b.getModel();
            if (PRESSED.equals(cmd)) {
                m.setArmed(true);
                m.setPressed(true);
                if (!b.isFocusOwner()) {
                    b.requestFocus();
                }
            } else if (RELEASED.equals(cmd)) {
                m.setPressed(false);
                m.setArmed(false);
            }
        }

        public boolean isEnabled(Object source) {
            boolean enabled = true;
            if (source instanceof AbstractButton) {
                AbstractButton b = (AbstractButton)source;
                enabled = b.isEnabled();
            }
            return enabled;
        }
    }
}

