/*
 * Decompiled with CFR 0.152.
 */
package java.nio.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderMalfunctionError;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public abstract class CharsetEncoder {
    private static final int STATE_RESET = 0;
    private static final int STATE_CODING = 1;
    private static final int STATE_END = 2;
    private static final int STATE_FLUSHED = 3;
    private static final byte[] DEFAULT_REPLACEMENT = new byte[]{63};
    private final Charset charset;
    private final float averageBytesPerChar;
    private final float maxBytesPerChar;
    private byte[] replacement;
    private int state = 0;
    private CodingErrorAction malformedInputAction = CodingErrorAction.REPORT;
    private CodingErrorAction unmappableCharacterAction = CodingErrorAction.REPORT;

    protected CharsetEncoder(Charset cs, float averageBytesPerChar, float maxBytesPerChar) {
        this(cs, averageBytesPerChar, maxBytesPerChar, DEFAULT_REPLACEMENT);
    }

    protected CharsetEncoder(Charset cs, float averageBytesPerChar, float maxBytesPerChar, byte[] replacement) {
        if (averageBytesPerChar <= 0.0f) {
            throw new IllegalArgumentException("Non-positive averageBytesPerChar");
        }
        if (maxBytesPerChar <= 0.0f) {
            throw new IllegalArgumentException("Non-positive maxBytesPerChar");
        }
        this.charset = cs;
        this.averageBytesPerChar = averageBytesPerChar;
        this.maxBytesPerChar = maxBytesPerChar;
        this.replacement = replacement;
        this.implReplaceWith(replacement);
    }

    public final float averageBytesPerChar() {
        return this.averageBytesPerChar;
    }

    public boolean canEncode(char c) {
        CharBuffer cb = CharBuffer.allocate(1).put(c);
        cb.flip();
        return this.canEncode(cb);
    }

    public boolean canEncode(CharSequence cs) {
        CharBuffer cb = cs instanceof CharBuffer ? ((CharBuffer)cs).duplicate() : CharBuffer.wrap(cs);
        return this.canEncode(cb);
    }

    private boolean canEncode(CharBuffer cb) {
        if (this.state == 3) {
            this.reset();
        } else if (this.state != 0) {
            throw new IllegalStateException();
        }
        CodingErrorAction oldMalformedInputAction = this.malformedInputAction;
        CodingErrorAction oldUnmappableCharacterAction = this.unmappableCharacterAction;
        try {
            try {
                if (oldMalformedInputAction != CodingErrorAction.REPORT) {
                    this.onMalformedInput(CodingErrorAction.REPORT);
                }
                if (oldUnmappableCharacterAction != CodingErrorAction.REPORT) {
                    this.onUnmappableCharacter(CodingErrorAction.REPORT);
                }
            }
            catch (Exception exception) {
                if (oldMalformedInputAction != CodingErrorAction.REPORT) {
                    this.onMalformedInput(oldMalformedInputAction);
                }
                if (oldUnmappableCharacterAction != CodingErrorAction.REPORT) {
                    this.onUnmappableCharacter(oldUnmappableCharacterAction);
                }
                return false;
            }
        }
        finally {
            if (oldMalformedInputAction != CodingErrorAction.REPORT) {
                this.onMalformedInput(oldMalformedInputAction);
            }
            if (oldUnmappableCharacterAction != CodingErrorAction.REPORT) {
                this.onUnmappableCharacter(oldUnmappableCharacterAction);
            }
        }
        return true;
    }

    public final Charset charset() {
        return this.charset;
    }

    public final ByteBuffer encode(CharBuffer in) throws CharacterCodingException {
        if (this.state != 0) {
            throw new IllegalStateException();
        }
        int remaining = in.remaining();
        int n = (int)((float)remaining * this.maxBytesPerChar());
        ByteBuffer out = ByteBuffer.allocate(n);
        if (remaining == 0) {
            this.state = 3;
            return out;
        }
        CoderResult cr = this.encode(in, out, true);
        if (cr.isError()) {
            cr.throwException();
        }
        if ((cr = this.flush(out)).isError()) {
            cr.throwException();
        }
        out.flip();
        byte[] resized = new byte[out.remaining()];
        out.get(resized);
        return ByteBuffer.wrap(resized);
    }

    public final CoderResult encode(CharBuffer in, ByteBuffer out, boolean endOfInput) {
        int newState;
        int n = newState = endOfInput ? 2 : 1;
        if (!(this.state == 0 || this.state == 1 || endOfInput && this.state == 2)) {
            throw new IllegalStateException();
        }
        this.state = newState;
        while (true) {
            CodingErrorAction action;
            CoderResult cr;
            try {
                cr = this.encodeLoop(in, out);
            }
            catch (RuntimeException e) {
                throw new CoderMalfunctionError(e);
            }
            if (cr.isOverflow()) {
                return cr;
            }
            if (cr.isUnderflow()) {
                if (endOfInput && in.hasRemaining()) {
                    cr = CoderResult.malformedForLength(in.remaining());
                } else {
                    return cr;
                }
            }
            CodingErrorAction codingErrorAction = action = cr.isMalformed() ? this.malformedInputAction : this.unmappableCharacterAction;
            if (action == CodingErrorAction.REPORT) {
                return cr;
            }
            if (action == CodingErrorAction.REPLACE) {
                if (out.remaining() < this.replacement.length) {
                    return CoderResult.OVERFLOW;
                }
                out.put(this.replacement);
            }
            in.position(in.position() + cr.length());
        }
    }

    protected abstract CoderResult encodeLoop(CharBuffer var1, ByteBuffer var2);

    public final CoderResult flush(ByteBuffer out) {
        if (this.state != 0 && this.state != 2) {
            throw new IllegalStateException();
        }
        this.state = 3;
        return this.implFlush(out);
    }

    protected CoderResult implFlush(ByteBuffer out) {
        return CoderResult.UNDERFLOW;
    }

    protected void implOnMalformedInput(CodingErrorAction newAction) {
    }

    protected void implOnUnmappableCharacter(CodingErrorAction newAction) {
    }

    protected void implReplaceWith(byte[] newReplacement) {
    }

    protected void implReset() {
    }

    public boolean isLegalReplacement(byte[] replacement) {
        CharBuffer cb;
        ByteBuffer bb;
        CharsetDecoder decoder = this.charset.newDecoder();
        return !decoder.decode(bb = ByteBuffer.wrap(replacement), cb = CharBuffer.allocate((int)((float)replacement.length * decoder.maxCharsPerByte())), true).isError();
    }

    public CodingErrorAction malformedInputAction() {
        return this.malformedInputAction;
    }

    public final float maxBytesPerChar() {
        return this.maxBytesPerChar;
    }

    public final CharsetEncoder onMalformedInput(CodingErrorAction newAction) {
        if (newAction == null) {
            throw new IllegalArgumentException("Null action");
        }
        this.malformedInputAction = newAction;
        this.implOnMalformedInput(newAction);
        return this;
    }

    public CodingErrorAction unmappableCharacterAction() {
        return this.unmappableCharacterAction;
    }

    public final CharsetEncoder onUnmappableCharacter(CodingErrorAction newAction) {
        if (newAction == null) {
            throw new IllegalArgumentException("Null action");
        }
        this.unmappableCharacterAction = newAction;
        this.implOnUnmappableCharacter(newAction);
        return this;
    }

    public final byte[] replacement() {
        return this.replacement;
    }

    public final CharsetEncoder replaceWith(byte[] newReplacement) {
        if (newReplacement == null) {
            throw new IllegalArgumentException("Null replacement");
        }
        if (newReplacement.length == 0) {
            throw new IllegalArgumentException("Empty replacement");
        }
        if (!this.isLegalReplacement(newReplacement)) {
            throw new IllegalArgumentException("Illegal replacement");
        }
        this.replacement = newReplacement;
        this.implReplaceWith(newReplacement);
        return this;
    }

    public final CharsetEncoder reset() {
        this.state = 0;
        this.implReset();
        return this;
    }
}

