/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.KeyExchangeAlgorithm;
import gnu.javax.net.ssl.provider.ServerKeyExchangeParams;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public class ServerRSAParams
implements ServerKeyExchangeParams {
    private final ByteBuffer buffer;

    public ServerRSAParams(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public KeyExchangeAlgorithm algorithm() {
        return KeyExchangeAlgorithm.RSA;
    }

    public int length() {
        int offset = this.buffer.getShort(0) & 0xFFFF;
        return (this.buffer.getShort(offset + 2) & 0xFFFF) + offset + 4;
    }

    public BigInteger modulus() {
        int len = this.buffer.getShort(0) & 0xFFFF;
        byte[] buf = new byte[len];
        this.buffer.position(2);
        this.buffer.get(buf);
        return new BigInteger(1, buf);
    }

    public BigInteger exponent() {
        int off = (this.buffer.getShort(0) & 0xFFFF) + 2;
        int len = this.buffer.getShort(off) & 0xFFFF;
        byte[] buf = new byte[len];
        this.buffer.position(off + 2);
        this.buffer.get(buf);
        return new BigInteger(1, buf);
    }

    public void setModulus(BigInteger modulus) {
        byte[] buf = modulus.toByteArray();
        int length = buf[0] == 0 ? buf.length - 1 : buf.length;
        int offset = buf[0] == 0 ? 1 : 0;
        this.buffer.putShort(0, (short)length);
        this.buffer.position(2);
        this.buffer.put(buf, offset, length);
    }

    public void setExponent(BigInteger exponent) {
        byte[] buf = exponent.toByteArray();
        int length = buf[0] == 0 ? buf.length - 1 : buf.length;
        int offset = buf[0] == 0 ? 1 : 0;
        int where = (this.buffer.getShort(0) & 0xFFFF) + 2;
        this.buffer.putShort(where, (short)length);
        this.buffer.position(where + 2);
        this.buffer.put(buf, offset, length);
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String prefix) {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        if (prefix != null) {
            out.print(prefix);
        }
        out.println("struct {");
        if (prefix != null) {
            out.print(prefix);
        }
        out.print("  rsa_modulus:  ");
        out.println(this.modulus().toString(16));
        if (prefix != null) {
            out.print(prefix);
        }
        out.print("  rsa_exponent: ");
        out.println(this.exponent());
        if (prefix != null) {
            out.print(prefix);
        }
        out.print("} ServerRSAParams;");
        return str.toString();
    }
}

