/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.ComboPopup;

public class BasicComboPopup
extends JPopupMenu
implements ComboPopup {
    protected Timer autoscrollTimer;
    protected JComboBox comboBox;
    protected boolean hasEntered;
    protected boolean isAutoScrolling;
    protected ItemListener itemListener;
    protected KeyListener keyListener;
    protected JList list;
    protected ListDataListener listDataListener;
    protected MouseListener listMouseListener;
    protected MouseMotionListener listMouseMotionListener;
    protected ListSelectionListener listSelectionListener;
    protected MouseListener mouseListener;
    protected MouseMotionListener mouseMotionListener;
    protected PropertyChangeListener propertyChangeListener;
    protected static final int SCROLL_DOWN = 1;
    protected static final int SCROLL_UP = 0;
    protected int scrollDirection;
    protected JScrollPane scroller;
    protected boolean valueIsAdjusting;

    public BasicComboPopup(JComboBox comboBox) {
        this.comboBox = comboBox;
        this.mouseListener = this.createMouseListener();
        this.mouseMotionListener = this.createMouseMotionListener();
        this.keyListener = this.createKeyListener();
        this.list = this.createList();
        this.configureList();
        this.scroller = this.createScroller();
        this.configureScroller();
        this.configurePopup();
        this.installComboBoxListeners();
        this.installKeyboardActions();
    }

    public void show() {
        Dimension size = this.comboBox.getSize();
        size.height = this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount());
        Insets i = this.getInsets();
        size.width -= i.left + i.right;
        Rectangle bounds = this.computePopupBounds(0, this.comboBox.getBounds().height, size.width, size.height);
        this.scroller.setMaximumSize(bounds.getSize());
        this.scroller.setPreferredSize(bounds.getSize());
        this.scroller.setMinimumSize(bounds.getSize());
        this.list.invalidate();
        this.syncListSelection();
        this.list.ensureIndexIsVisible(this.list.getSelectedIndex());
        this.setLightWeightPopupEnabled(this.comboBox.isLightWeightPopupEnabled());
        this.show(this.comboBox, bounds.x, bounds.y);
    }

    public void hide() {
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        MenuElement[] menuElements = menuSelectionManager.getSelectedPath();
        int i = 0;
        while (i < menuElements.length) {
            if (menuElements[i] == this) {
                menuSelectionManager.clearSelectedPath();
                break;
            }
            ++i;
        }
        this.comboBox.repaint();
    }

    public JList getList() {
        return this.list;
    }

    public MouseListener getMouseListener() {
        return this.mouseListener;
    }

    public MouseMotionListener getMouseMotionListener() {
        return this.mouseMotionListener;
    }

    public KeyListener getKeyListener() {
        return this.keyListener;
    }

    public void uninstallingUI() {
        if (this.propertyChangeListener != null) {
            this.comboBox.removePropertyChangeListener(this.propertyChangeListener);
        }
        if (this.itemListener != null) {
            this.comboBox.removeItemListener(this.itemListener);
        }
        this.uninstallComboBoxModelListeners(this.comboBox.getModel());
        this.uninstallKeyboardActions();
        this.uninstallListListeners();
    }

    protected void uninstallComboBoxModelListeners(ComboBoxModel model) {
        model.removeListDataListener(this.listDataListener);
    }

    protected void uninstallKeyboardActions() {
    }

    protected void firePopupMenuWillBecomeVisible() {
        PopupMenuListener[] ll = this.comboBox.getPopupMenuListeners();
        int i = 0;
        while (i < ll.length) {
            ll[i].popupMenuWillBecomeVisible(new PopupMenuEvent(this.comboBox));
            ++i;
        }
    }

    protected void firePopupMenuWillBecomeInvisible() {
        PopupMenuListener[] ll = this.comboBox.getPopupMenuListeners();
        int i = 0;
        while (i < ll.length) {
            ll[i].popupMenuWillBecomeInvisible(new PopupMenuEvent(this.comboBox));
            ++i;
        }
    }

    protected void firePopupMenuCanceled() {
        PopupMenuListener[] ll = this.comboBox.getPopupMenuListeners();
        int i = 0;
        while (i < ll.length) {
            ll[i].popupMenuCanceled(new PopupMenuEvent(this.comboBox));
            ++i;
        }
    }

    protected MouseListener createMouseListener() {
        return new InvocationMouseHandler();
    }

    protected MouseMotionListener createMouseMotionListener() {
        return new InvocationMouseMotionHandler();
    }

    protected KeyListener createKeyListener() {
        return new InvocationKeyHandler();
    }

    protected ListSelectionListener createListSelectionListener() {
        return new ListSelectionHandler();
    }

    protected ListDataListener createListDataListener() {
        return null;
    }

    protected MouseListener createListMouseListener() {
        return new ListMouseHandler();
    }

    protected MouseMotionListener createListMouseMotionListener() {
        return new ListMouseMotionHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected ItemListener createItemListener() {
        return new ItemHandler();
    }

    protected JList createList() {
        JList l = new JList(this.comboBox.getModel());
        return l;
    }

    protected void configureList() {
        this.list.setFont(this.comboBox.getFont());
        this.list.setForeground(this.comboBox.getForeground());
        this.list.setBackground(this.comboBox.getBackground());
        Color sfg = UIManager.getColor("ComboBox.selectionForeground");
        this.list.setSelectionForeground(sfg);
        Color sbg = UIManager.getColor("ComboBox.selectionBackground");
        this.list.setSelectionBackground(sbg);
        this.list.setBorder(null);
        this.list.setCellRenderer(this.comboBox.getRenderer());
        this.list.setFocusable(false);
        this.list.setSelectionMode(1);
        this.installListListeners();
    }

    protected void installListListeners() {
        this.listMouseListener = this.createListMouseListener();
        this.list.addMouseListener(this.listMouseListener);
        this.listMouseMotionListener = this.createListMouseMotionListener();
        this.list.addMouseMotionListener(this.listMouseMotionListener);
        this.listSelectionListener = this.createListSelectionListener();
        this.list.addListSelectionListener(this.listSelectionListener);
    }

    protected JScrollPane createScroller() {
        return new JScrollPane(this.list, 20, 31);
    }

    protected void configureScroller() {
        this.scroller.setBorder(null);
        this.scroller.setFocusable(false);
        this.scroller.getVerticalScrollBar().setFocusable(false);
    }

    protected void configurePopup() {
        this.setBorderPainted(true);
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.setOpaque(false);
        this.add(this.scroller);
        this.setFocusable(false);
    }

    protected void installComboBoxListeners() {
        this.itemListener = this.createItemListener();
        this.comboBox.addItemListener(this.itemListener);
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.comboBox.addPropertyChangeListener(this.propertyChangeListener);
        this.installComboBoxModelListeners(this.comboBox.getModel());
    }

    protected void installComboBoxModelListeners(ComboBoxModel model) {
        this.listDataListener = this.createListDataListener();
        this.comboBox.getModel().addListDataListener(this.listDataListener);
    }

    protected void installKeyboardActions() {
    }

    public boolean isFocusTraversable() {
        return false;
    }

    protected void startAutoScrolling(int direction) {
        this.isAutoScrolling = true;
        if (direction == 0) {
            this.autoScrollUp();
        } else {
            this.autoScrollDown();
        }
    }

    protected void stopAutoScrolling() {
        this.isAutoScrolling = false;
    }

    protected void autoScrollUp() {
        JScrollBar scrollbar = this.scroller.getVerticalScrollBar();
        int scrollToNext = this.list.getScrollableUnitIncrement(super.getBounds(), 1, 0);
        scrollbar.setValue(scrollbar.getValue() - scrollToNext);
        if (this.list.getSelectedIndex() != 0) {
            this.list.setSelectedIndex(this.list.getSelectedIndex() - 1);
        }
    }

    protected void autoScrollDown() {
        JScrollBar scrollbar = this.scroller.getVerticalScrollBar();
        int scrollToNext = this.list.getScrollableUnitIncrement(super.getBounds(), 1, 1);
        scrollbar.setValue(scrollbar.getValue() + scrollToNext);
        if (this.list.getSelectedIndex() + 1 != this.comboBox.getItemCount()) {
            this.list.setSelectedIndex(this.list.getSelectedIndex() + 1);
        }
    }

    protected void delegateFocus(MouseEvent e) {
        if (this.comboBox.isEditable()) {
            this.comboBox.getEditor().getEditorComponent().requestFocus();
        } else {
            this.comboBox.requestFocus();
        }
    }

    protected void togglePopup() {
        if (this.isVisible()) {
            this.hide();
        } else {
            this.show();
        }
    }

    protected MouseEvent convertMouseEvent(MouseEvent e) {
        Point point = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), this.list);
        MouseEvent newEvent = new MouseEvent((Component)e.getSource(), e.getID(), e.getWhen(), e.getModifiers(), point.x, point.y, e.getModifiers(), e.isPopupTrigger());
        return newEvent;
    }

    protected int getPopupHeightForRowCount(int maxRowCount) {
        int totalHeight = 0;
        ListCellRenderer rend = this.list.getCellRenderer();
        if (this.comboBox.getItemCount() < maxRowCount) {
            maxRowCount = this.comboBox.getItemCount();
        }
        int i = 0;
        while (i < maxRowCount) {
            Component comp = rend.getListCellRendererComponent(this.list, this.comboBox.getModel().getElementAt(i), -1, false, false);
            Dimension dim = comp.getPreferredSize();
            totalHeight += dim.height;
            ++i;
        }
        return totalHeight == 0 ? 100 : totalHeight;
    }

    protected Rectangle computePopupBounds(int px, int py, int pw, int ph) {
        return new Rectangle(px, py, pw, ph);
    }

    protected void updateListBoxSelectionForEvent(MouseEvent anEvent, boolean shouldScroll) {
        Point point = anEvent.getPoint();
        if (this.list != null) {
            int index = this.list.locationToIndex(point);
            if (index == -1) {
                index = point.y < 0 ? 0 : this.comboBox.getModel().getSize() - 1;
            }
            if (this.list.getSelectedIndex() != index) {
                this.list.setSelectedIndex(index);
                if (shouldScroll) {
                    this.list.ensureIndexIsVisible(index);
                }
            }
        }
    }

    private void uninstallListListeners() {
        this.list.removeMouseListener(this.listMouseListener);
        this.listMouseListener = null;
        this.list.removeMouseMotionListener(this.listMouseMotionListener);
        this.listMouseMotionListener = null;
    }

    void syncListSelection() {
        int index = this.comboBox.getSelectedIndex();
        if (index == -1) {
            this.list.clearSelection();
        } else {
            this.list.setSelectedIndex(index);
        }
    }

    public class InvocationKeyHandler
    extends KeyAdapter {
        public void keyReleased(KeyEvent e) {
        }
    }

    protected class InvocationMouseHandler
    extends MouseAdapter {
        protected InvocationMouseHandler() {
        }

        public void mousePressed(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e) && BasicComboPopup.this.comboBox.isEnabled()) {
                BasicComboPopup.this.delegateFocus(e);
                BasicComboPopup.this.togglePopup();
            }
        }

        public void mouseReleased(MouseEvent e) {
            Component component = (Component)e.getSource();
            Dimension size = component.getSize();
            Rectangle bounds = new Rectangle(0, 0, size.width - 1, size.height - 1);
            if (!bounds.contains(e.getPoint())) {
                MouseEvent convEvent = BasicComboPopup.this.convertMouseEvent(e);
                Point point = convEvent.getPoint();
                Rectangle visRect = new Rectangle();
                BasicComboPopup.this.list.computeVisibleRect(visRect);
                if (visRect.contains(point)) {
                    BasicComboPopup.this.updateListBoxSelectionForEvent(convEvent, false);
                    BasicComboPopup.this.comboBox.setSelectedIndex(BasicComboPopup.this.list.getSelectedIndex());
                }
                BasicComboPopup.this.hide();
            }
            BasicComboPopup.this.hasEntered = false;
            BasicComboPopup.this.stopAutoScrolling();
        }
    }

    protected class InvocationMouseMotionHandler
    extends MouseMotionAdapter {
        protected InvocationMouseMotionHandler() {
        }

        public void mouseDragged(MouseEvent e) {
            if (BasicComboPopup.this.isVisible()) {
                MouseEvent convEvent = BasicComboPopup.this.convertMouseEvent(e);
                Rectangle visRect = new Rectangle();
                BasicComboPopup.this.list.computeVisibleRect(visRect);
                if (convEvent.getPoint().y >= visRect.y && convEvent.getPoint().y <= visRect.y + visRect.height - 1) {
                    Point point;
                    BasicComboPopup.this.hasEntered = true;
                    if (BasicComboPopup.this.isAutoScrolling) {
                        BasicComboPopup.this.stopAutoScrolling();
                    }
                    if (visRect.contains(point = convEvent.getPoint())) {
                        BasicComboPopup.this.valueIsAdjusting = true;
                        BasicComboPopup.this.updateListBoxSelectionForEvent(convEvent, false);
                        BasicComboPopup.this.valueIsAdjusting = false;
                    }
                } else if (BasicComboPopup.this.hasEntered) {
                    int dir;
                    int n = dir = convEvent.getPoint().y < visRect.y ? 0 : 1;
                    if (BasicComboPopup.this.isAutoScrolling && BasicComboPopup.this.scrollDirection != dir) {
                        BasicComboPopup.this.stopAutoScrolling();
                        BasicComboPopup.this.startAutoScrolling(dir);
                    } else if (!BasicComboPopup.this.isAutoScrolling) {
                        BasicComboPopup.this.startAutoScrolling(dir);
                    }
                } else if (e.getPoint().y < 0) {
                    BasicComboPopup.this.hasEntered = true;
                    BasicComboPopup.this.startAutoScrolling(0);
                }
            }
        }
    }

    protected class ItemHandler
    implements ItemListener {
        protected ItemHandler() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1 && !BasicComboPopup.this.valueIsAdjusting) {
                BasicComboPopup.this.valueIsAdjusting = true;
                BasicComboPopup.this.syncListSelection();
                BasicComboPopup.this.valueIsAdjusting = false;
                BasicComboPopup.this.list.ensureIndexIsVisible(BasicComboPopup.this.comboBox.getSelectedIndex());
            }
        }
    }

    public class ListDataHandler
    implements ListDataListener {
        public void contentsChanged(ListDataEvent e) {
        }

        public void intervalAdded(ListDataEvent e) {
        }

        public void intervalRemoved(ListDataEvent e) {
        }
    }

    protected class ListMouseHandler
    extends MouseAdapter {
        protected ListMouseHandler() {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent anEvent) {
            BasicComboPopup.this.comboBox.setSelectedIndex(BasicComboPopup.this.list.getSelectedIndex());
            BasicComboPopup.this.hide();
        }
    }

    protected class ListMouseMotionHandler
    extends MouseMotionAdapter {
        protected ListMouseMotionHandler() {
        }

        public void mouseMoved(MouseEvent anEvent) {
            Point point = anEvent.getPoint();
            Rectangle visRect = new Rectangle();
            BasicComboPopup.this.list.computeVisibleRect(visRect);
            if (visRect.contains(point)) {
                BasicComboPopup.this.valueIsAdjusting = true;
                BasicComboPopup.this.updateListBoxSelectionForEvent(anEvent, false);
                BasicComboPopup.this.valueIsAdjusting = false;
            }
        }
    }

    protected class ListSelectionHandler
    implements ListSelectionListener {
        protected ListSelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent e) {
        }
    }

    protected class PropertyChangeHandler
    implements PropertyChangeListener {
        protected PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("renderer")) {
                BasicComboPopup.this.list.setCellRenderer(BasicComboPopup.this.comboBox.getRenderer());
                if (BasicComboPopup.this.isVisible()) {
                    BasicComboPopup.this.hide();
                }
            }
            if (e.getPropertyName().equals("model")) {
                ComboBoxModel oldModel = (ComboBoxModel)e.getOldValue();
                BasicComboPopup.this.uninstallComboBoxModelListeners(oldModel);
                ComboBoxModel newModel = (ComboBoxModel)e.getNewValue();
                BasicComboPopup.this.list.setModel(newModel);
                BasicComboPopup.this.installComboBoxModelListeners(newModel);
                if (BasicComboPopup.this.comboBox.getItemCount() > 0) {
                    BasicComboPopup.this.comboBox.setSelectedIndex(0);
                }
                if (BasicComboPopup.this.isVisible()) {
                    BasicComboPopup.this.hide();
                }
            }
        }
    }
}

