/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.activation;

import gnu.java.rmi.activation.DefaultActivationGroup;
import java.io.Serializable;
import java.rmi.MarshalledObject;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import java.util.TreeSet;
import java.util.zip.Adler32;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ActivationGroupDesc
implements Serializable {
    static final long serialVersionUID = -4936225423168276595L;
    final String className;
    final String location;
    final MarshalledObject<?> data;
    final CommandEnvironment env;
    final Properties props;
    transient long hash;

    public ActivationGroupDesc(Properties aProperties, CommandEnvironment environment) {
        this(DefaultActivationGroup.class.getName(), null, null, aProperties, environment);
    }

    public ActivationGroupDesc(String aClassName, String aLocation, MarshalledObject<?> aData, Properties aProperties, CommandEnvironment environment) {
        this.className = aClassName;
        this.location = aLocation;
        this.data = aData;
        this.props = aProperties;
        this.env = environment;
    }

    public String getClassName() {
        return this.className;
    }

    public String getLocation() {
        return this.location;
    }

    public MarshalledObject<?> getData() {
        return this.data;
    }

    public Properties getPropertyOverrides() {
        return this.props;
    }

    public CommandEnvironment getCommandEnvironment() {
        return this.env;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ActivationGroupDesc) {
            ActivationGroupDesc that = (ActivationGroupDesc)obj;
            if (this.hash == 0L) {
                this.hashCode();
            }
            if (that.hash == 0L) {
                that.hashCode();
            }
            if (this.hash != that.hash) {
                return false;
            }
            if (!ActivationGroupDesc.eq(this.className, that.className)) {
                return false;
            }
            if (!ActivationGroupDesc.eq(this.data, that.data)) {
                return false;
            }
            if (!ActivationGroupDesc.eq(this.env, that.env)) {
                return false;
            }
            if (!ActivationGroupDesc.eq(this.location, that.location)) {
                return false;
            }
            if (ActivationGroupDesc.eq(this.props, that.props)) {
                return true;
            }
            if (this.props.size() != that.props.size()) {
                return false;
            }
            Enumeration<?> en = this.props.propertyNames();
            while (en.hasMoreElements()) {
                Object key = en.nextElement();
                if (!that.props.containsKey(key)) {
                    return false;
                }
                if (ActivationGroupDesc.eq(this.props.get(key), that.props.get(key))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static boolean eq(Object a, Object b) {
        if (a == null || b == null) {
            return a == b;
        }
        return a.equals(b);
    }

    public int hashCode() {
        if (this.hash == 0L) {
            Adler32 adler = new Adler32();
            if (this.className != null) {
                adler.update(this.className.getBytes());
            }
            if (this.data != null) {
                adler.update(this.data.hashCode());
            }
            if (this.env != null) {
                adler.update(this.env.hashCode());
            }
            if (this.location != null) {
                adler.update(this.location.getBytes());
            }
            if (this.props != null) {
                Enumeration<?> en = this.props.propertyNames();
                TreeSet pr = new TreeSet();
                while (en.hasMoreElements()) {
                    Object key = en.nextElement();
                    if (key == null) continue;
                    pr.add(key);
                }
                for (Object key : pr) {
                    Object value = this.props.get(key);
                    adler.update(key.hashCode());
                    if (value == null) continue;
                    adler.update(value.hashCode());
                }
            }
            this.hash = adler.getValue();
        }
        return (int)this.hash;
    }

    public static class CommandEnvironment
    implements Serializable {
        static final long serialVersionUID = 6165754737887770191L;
        private static final String[] NO_ARGS = new String[0];
        final String command;
        final String[] options;

        public CommandEnvironment(String commandPatch, String[] args) {
            this.command = commandPatch;
            this.options = args != null ? args : NO_ARGS;
        }

        public String getCommandPath() {
            return this.command;
        }

        public String[] getCommandOptions() {
            return this.options;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CommandEnvironment) {
                CommandEnvironment that = (CommandEnvironment)obj;
                if (this.command == null || that.command == null ? this.command != that.command : !this.command.equals(that.command)) {
                    return false;
                }
                return Arrays.equals(this.options, that.options);
            }
            return false;
        }

        public int hashCode() {
            int h = this.command == null ? 0 : this.command.hashCode();
            int i = 0;
            while (i < this.options.length) {
                h ^= this.options[i].hashCode();
                ++i;
            }
            return h;
        }
    }
}

