/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.prng;

import gnu.java.security.Properties;
import gnu.java.security.hash.HashFactory;
import gnu.java.security.hash.IMessageDigest;
import gnu.java.security.prng.BasePRNG;
import gnu.java.security.prng.EntropySource;
import gnu.java.security.prng.IRandom;
import gnu.java.security.prng.LimitReachedException;
import gnu.java.security.util.SimpleList;
import gnu.javax.crypto.cipher.CipherFactory;
import gnu.javax.crypto.cipher.IBlockCipher;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class CSPRNG
extends BasePRNG {
    private static final Logger log = Logger.getLogger(CSPRNG.class.getName());
    public static final String FILE_SOURCES = "gnu.crypto.prng.pool.files";
    public static final String URL_SOURCES = "gnu.crypto.prng.pool.urls";
    public static final String PROGRAM_SOURCES = "gnu.crypto.prng.pool.programs";
    public static final String OTHER_SOURCES = "gnu.crypto.prng.pool.other";
    public static final String BLOCKING = "gnu.crypto.prng.pool.blocking";
    private static final String FILES = "gnu.crypto.csprng.file.";
    private static final String URLS = "gnu.crypto.csprng.url.";
    private static final String PROGS = "gnu.crypto.csprng.program.";
    private static final String OTHER = "gnu.crypto.csprng.other.";
    private static final String BLOCK = "gnu.crypto.csprng.blocking";
    private static final int POOL_SIZE = 256;
    private static final int ALLOC_SIZE = 260;
    private static final int OUTPUT_SIZE = 128;
    private static final int X917_POOL_SIZE = 16;
    private static final String HASH_FUNCTION = "sha-160";
    private static final String CIPHER = "aes";
    private static final int MIX_COUNT = 10;
    private static final int X917_LIFETIME = 8192;
    private static final int SPINNER_COUNT = 8;
    private static final Spinner[] SPINNERS = new Spinner[8];
    private static final Thread[] SPINNER_THREADS = new Thread[8];
    private final IMessageDigest hash;
    private final IBlockCipher cipher;
    private int mixCount;
    private final byte[] pool = new byte[260];
    private double quality = 0.0;
    private int index;
    private byte[] x917pool = new byte[16];
    private int x917count = 0;
    private boolean x917init = false;
    private final List files;
    private final List urls;
    private final List progs;
    private final List other;
    private boolean blocking;
    private Poller poller;
    private Thread pollerThread;

    static {
        int i = 0;
        while (i < 8) {
            CSPRNG.SPINNERS[i] = new Spinner();
            CSPRNG.SPINNER_THREADS[i] = new Thread(CSPRNG.SPINNERS[i], "spinner-" + i);
            SPINNER_THREADS[i].setDaemon(true);
            SPINNER_THREADS[i].setPriority(1);
            SPINNER_THREADS[i].start();
            ++i;
        }
    }

    public CSPRNG() {
        super("CSPRNG");
        this.hash = HashFactory.getInstance(HASH_FUNCTION);
        this.cipher = CipherFactory.getInstance(CIPHER);
        this.buffer = new byte[128];
        this.ndx = 0;
        this.initialised = false;
        this.files = new LinkedList();
        this.urls = new LinkedList();
        this.progs = new LinkedList();
        this.other = new LinkedList();
    }

    public static IRandom getSystemInstance() throws ClassNotFoundException, MalformedURLException, NumberFormatException {
        CSPRNG instance = new CSPRNG();
        HashMap<String, Serializable> attrib = new HashMap<String, Serializable>();
        attrib.put(BLOCKING, Boolean.valueOf(CSPRNG.getProperty(BLOCK)));
        String s = null;
        LinkedList l = new LinkedList();
        int i = 0;
        while ((s = CSPRNG.getProperty(FILES + i)) != null) {
            try {
                l.add(CSPRNG.parseString(s.trim()));
            }
            catch (NumberFormatException numberFormatException) {}
            ++i;
        }
        attrib.put(FILE_SOURCES, l);
        l = new LinkedList();
        i = 0;
        while ((s = CSPRNG.getProperty(URLS + i)) != null) {
            try {
                l.add(CSPRNG.parseURL(s.trim()));
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (MalformedURLException malformedURLException) {}
            ++i;
        }
        attrib.put(URL_SOURCES, l);
        l = new LinkedList();
        i = 0;
        while ((s = CSPRNG.getProperty(PROGS + i)) != null) {
            try {
                l.add(CSPRNG.parseString(s.trim()));
            }
            catch (NumberFormatException numberFormatException) {}
            ++i;
        }
        attrib.put(PROGRAM_SOURCES, l);
        l = new LinkedList();
        i = 0;
        while ((s = CSPRNG.getProperty(OTHER + i)) != null) {
            try {
                Class<?> c = Class.forName(s.trim());
                l.add(c.newInstance());
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
            ++i;
        }
        attrib.put(OTHER_SOURCES, l);
        instance.init(attrib);
        return instance;
    }

    private static String getProperty(final String name) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Properties.getProperty(name);
            }
        });
    }

    private static List parseString(String s) throws NumberFormatException {
        StringTokenizer tok = new StringTokenizer(s, ";");
        if (tok.countTokens() != 4) {
            throw new IllegalArgumentException("malformed property");
        }
        Double quality = new Double(tok.nextToken());
        Integer offset = new Integer(tok.nextToken());
        Integer length = new Integer(tok.nextToken());
        String str = tok.nextToken();
        return new SimpleList(quality, offset, length, str);
    }

    private static List parseURL(String s) throws MalformedURLException, NumberFormatException {
        StringTokenizer tok = new StringTokenizer(s, ";");
        if (tok.countTokens() != 4) {
            throw new IllegalArgumentException("malformed property");
        }
        Double quality = new Double(tok.nextToken());
        Integer offset = new Integer(tok.nextToken());
        Integer length = new Integer(tok.nextToken());
        URL url = new URL(tok.nextToken());
        return new SimpleList(quality, offset, length, url);
    }

    public Object clone() {
        return new CSPRNG();
    }

    public void setup(Map attrib) {
        Object source;
        Integer length;
        Integer offset;
        Double quality;
        List list2 = null;
        try {
            list2 = (List)attrib.get(FILE_SOURCES);
            if (list2 != null) {
                this.files.clear();
                for (List l : list2) {
                    if (l.size() != 4) {
                        throw new IllegalArgumentException("invalid file list");
                    }
                    quality = (Double)l.get(0);
                    offset = (Integer)l.get(1);
                    length = (Integer)l.get(2);
                    source = (String)l.get(3);
                    this.files.add(new SimpleList(quality, offset, length, source));
                }
            }
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("invalid file list");
        }
        try {
            list2 = (List)attrib.get(URL_SOURCES);
            if (list2 != null) {
                this.urls.clear();
                for (List l : list2) {
                    if (l.size() != 4) {
                        throw new IllegalArgumentException("invalid URL list");
                    }
                    quality = (Double)l.get(0);
                    offset = (Integer)l.get(1);
                    length = (Integer)l.get(2);
                    source = (URL)l.get(3);
                    this.urls.add(new SimpleList(quality, offset, length, source));
                }
            }
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("invalid URL list");
        }
        try {
            list2 = (List)attrib.get(PROGRAM_SOURCES);
            if (list2 != null) {
                this.progs.clear();
                for (List l : list2) {
                    if (l.size() != 4) {
                        throw new IllegalArgumentException("invalid program list");
                    }
                    quality = (Double)l.get(0);
                    offset = (Integer)l.get(1);
                    length = (Integer)l.get(2);
                    source = (String)l.get(3);
                    this.progs.add(new SimpleList(quality, offset, length, source));
                }
            }
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("invalid program list");
        }
        try {
            list2 = (List)attrib.get(OTHER_SOURCES);
            if (list2 != null) {
                this.other.clear();
                for (EntropySource src : list2) {
                    if (src == null) {
                        throw new NullPointerException("null source in source list");
                    }
                    this.other.add(src);
                }
            }
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("invalid source list");
        }
        try {
            Boolean block = (Boolean)attrib.get(BLOCKING);
            this.blocking = block != null ? block : true;
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("invalid blocking parameter");
        }
        this.poller = new Poller(this.files, this.urls, this.progs, this.other, this);
        try {
            this.fillBlock();
        }
        catch (LimitReachedException limitReachedException) {
            throw new RuntimeException("bootstrapping CSPRNG failed");
        }
    }

    public void fillBlock() throws LimitReachedException {
        if (this.getQuality() < 100.0) {
            this.slowPoll();
        }
        do {
            this.fastPoll();
            this.mixRandomPool();
        } while (this.mixCount < 10);
        if (!this.x917init || this.x917count >= 8192) {
            this.mixRandomPool(this.pool);
            HashMap<String, byte[]> attr = new HashMap<String, byte[]>();
            byte[] key = new byte[32];
            System.arraycopy(this.pool, 0, key, 0, 32);
            this.cipher.reset();
            attr.put("gnu.crypto.cipher.key.material", key);
            try {
                this.cipher.init(attr);
            }
            catch (InvalidKeyException ike) {
                throw new Error(ike.toString());
            }
            this.mixRandomPool(this.pool);
            this.generateX917(this.pool);
            this.mixRandomPool(this.pool);
            this.generateX917(this.pool);
            if (this.x917init) {
                this.quality = 0.0;
            }
            this.x917init = true;
            this.x917count = 0;
        }
        byte[] export = new byte[260];
        int i = 0;
        while (i < 260) {
            export[i] = (byte)(this.pool[i] ^ 0xFF);
            ++i;
        }
        this.mixRandomPool();
        this.mixRandomPool(export);
        this.generateX917(export);
        i = 0;
        while (i < 128) {
            this.buffer[i] = (byte)(export[i] ^ export[i + 128]);
            ++i;
        }
        Arrays.fill(export, (byte)0);
    }

    public synchronized void addRandomBytes(byte[] buf, int off, int len) {
        if (off < 0 || len < 0 || off + len > buf.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int count = off + len;
        int i = off;
        while (i < count) {
            int n = this.index++;
            this.pool[n] = (byte)(this.pool[n] ^ buf[i]);
            if (this.index == this.pool.length) {
                this.mixRandomPool();
                this.index = 0;
            }
            ++i;
        }
    }

    public synchronized void addRandomByte(byte b) {
        int n = this.index++;
        this.pool[n] = (byte)(this.pool[n] ^ b);
        if (this.index >= this.pool.length) {
            this.mixRandomPool();
            this.index = 0;
        }
    }

    synchronized void addQuality(double quality) {
        if (this.quality < 100.0) {
            this.quality += quality;
        }
    }

    synchronized double getQuality() {
        return this.quality;
    }

    private void mixRandomPool(byte[] buf) {
        int hashSize = this.hash.hashSize();
        int i = 0;
        while (i < buf.length) {
            if (i == 0) {
                this.hash.update(buf, buf.length - hashSize, hashSize);
            } else {
                this.hash.update(buf, i - hashSize, hashSize);
            }
            if (i + 64 < buf.length) {
                this.hash.update(buf, i, 64);
            } else {
                this.hash.update(buf, i, buf.length - i);
                this.hash.update(buf, 0, 64 - (buf.length - i));
            }
            byte[] digest = this.hash.digest();
            System.arraycopy(digest, 0, buf, i, hashSize);
            i += hashSize;
        }
    }

    private void mixRandomPool() {
        this.mixRandomPool(this.pool);
        ++this.mixCount;
    }

    private void generateX917(byte[] buf) {
        int off = 0;
        int i = 0;
        while (i < buf.length) {
            int copy = Math.min(buf.length - i, 16);
            int j = 0;
            while (j < copy) {
                int n = j;
                this.x917pool[n] = (byte)(this.x917pool[n] ^ this.pool[off + j]);
                ++j;
            }
            this.cipher.encryptBlock(this.x917pool, 0, this.x917pool, 0);
            System.arraycopy(this.x917pool, 0, buf, off, copy);
            this.cipher.encryptBlock(this.x917pool, 0, this.x917pool, 0);
            off += copy;
            ++this.x917count;
            i += 16;
        }
    }

    private void fastPoll() {
        byte b = 0;
        int i = 0;
        while (i < 8) {
            b = (byte)(b ^ CSPRNG.SPINNERS[i].counter);
            ++i;
        }
        this.addRandomByte(b);
        this.addRandomByte((byte)System.currentTimeMillis());
        this.addRandomByte((byte)Runtime.getRuntime().freeMemory());
        String s = Thread.currentThread().getName();
        if (s != null) {
            byte[] buf = s.getBytes();
            this.addRandomBytes(buf, 0, buf.length);
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream(1024);
        PrintStream pout = new PrintStream(bout);
        Throwable t = new Throwable();
        t.printStackTrace(pout);
        pout.flush();
        byte[] buf = bout.toByteArray();
        this.addRandomBytes(buf, 0, buf.length);
    }

    private void slowPoll() throws LimitReachedException {
        if (this.pollerThread == null || !this.pollerThread.isAlive()) {
            boolean interrupted = false;
            this.pollerThread = new Thread(this.poller);
            this.pollerThread.setDaemon(true);
            this.pollerThread.setPriority(4);
            this.pollerThread.start();
            if (this.blocking) {
                try {
                    this.pollerThread.join();
                }
                catch (InterruptedException interruptedException) {
                    interrupted = true;
                }
            }
            if (!interrupted && this.blocking && this.quality < 100.0) {
                throw new LimitReachedException("insufficient randomness was polled");
            }
        }
    }

    protected void finalize() throws Throwable {
        if (this.poller != null && this.pollerThread != null && this.pollerThread.isAlive()) {
            this.pollerThread.interrupt();
            this.poller.stopUpdating();
            this.pollerThread.interrupt();
        }
        Arrays.fill(this.pool, (byte)0);
        Arrays.fill(this.x917pool, (byte)0);
        Arrays.fill(this.buffer, (byte)0);
    }

    private final class Poller
    implements Runnable {
        private final List files;
        private final List urls;
        private final List progs;
        private final List other;
        private final CSPRNG pool;
        private boolean running;

        Poller(List files, List urls, List progs, List other, CSPRNG pool) {
            this.files = Collections.unmodifiableList(files);
            this.urls = Collections.unmodifiableList(urls);
            this.progs = Collections.unmodifiableList(progs);
            this.other = Collections.unmodifiableList(other);
            this.pool = pool;
        }

        public void run() {
            this.running = true;
            Iterator files_it = this.files.iterator();
            Iterator urls_it = this.urls.iterator();
            Iterator prog_it = this.progs.iterator();
            Iterator other_it = this.other.iterator();
            while (files_it.hasNext() || urls_it.hasNext() || prog_it.hasNext() || other_it.hasNext()) {
                int len;
                byte[] buf;
                InputStream in;
                Object src;
                int count;
                int offset;
                double qual;
                List l2;
                if (this.pool.getQuality() >= 100.0 || !this.running) {
                    return;
                }
                if (files_it.hasNext()) {
                    try {
                        l2 = (List)files_it.next();
                        qual = (Double)l2.get(0);
                        offset = (Integer)l2.get(1);
                        count = (Integer)l2.get(2);
                        src = (String)l2.get(3);
                        in = new FileInputStream((String)src);
                        buf = new byte[count];
                        if (offset > 0) {
                            in.skip(offset);
                        }
                        if ((len = in.read(buf)) >= 0) {
                            this.pool.addRandomBytes(buf, 0, len);
                            this.pool.addQuality(qual * ((double)len / (double)count));
                        }
                    }
                    catch (Exception l2) {
                        // empty catch block
                    }
                }
                if (this.pool.getQuality() >= 100.0 || !this.running) {
                    return;
                }
                if (urls_it.hasNext()) {
                    try {
                        l2 = (List)urls_it.next();
                        qual = (Double)l2.get(0);
                        offset = (Integer)l2.get(1);
                        count = (Integer)l2.get(2);
                        src = (URL)l2.get(3);
                        in = ((URL)src).openStream();
                        buf = new byte[count];
                        if (offset > 0) {
                            in.skip(offset);
                        }
                        if ((len = in.read(buf)) >= 0) {
                            this.pool.addRandomBytes(buf, 0, len);
                            this.pool.addQuality(qual * ((double)len / (double)count));
                        }
                    }
                    catch (Exception l3) {
                        // empty catch block
                    }
                }
                if (this.pool.getQuality() >= 100.0 || !this.running) {
                    return;
                }
                Process proc = null;
                if (prog_it.hasNext()) {
                    try {
                        int len2;
                        List l4 = (List)prog_it.next();
                        double qual2 = (Double)l4.get(0);
                        int offset2 = (Integer)l4.get(1);
                        int count2 = (Integer)l4.get(2);
                        String src2 = (String)l4.get(3);
                        proc = null;
                        proc = Runtime.getRuntime().exec(src2);
                        InputStream in2 = proc.getInputStream();
                        byte[] buf2 = new byte[count2];
                        if (offset2 > 0) {
                            in2.skip(offset2);
                        }
                        if ((len2 = in2.read(buf2)) >= 0) {
                            this.pool.addRandomBytes(buf2, 0, len2);
                            this.pool.addQuality(qual2 * ((double)len2 / (double)count2));
                        }
                        proc.destroy();
                        proc.waitFor();
                    }
                    catch (Exception x) {
                        try {
                            if (proc != null) {
                                proc.destroy();
                                proc.waitFor();
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
                if (this.pool.getQuality() >= 100.0 || !this.running) {
                    return;
                }
                if (!other_it.hasNext()) continue;
                try {
                    EntropySource src3 = (EntropySource)other_it.next();
                    byte[] buf3 = src3.nextBytes();
                    if (this.pool == null) {
                        return;
                    }
                    this.pool.addRandomBytes(buf3, 0, buf3.length);
                    this.pool.addQuality(src3.quality());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void stopUpdating() {
            this.running = false;
        }
    }

    private static class Spinner
    implements Runnable {
        protected byte counter;

        private Spinner() {
        }

        public void run() {
            while (true) {
                this.counter = (byte)(this.counter + 1);
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

