/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.swing.text.html.css;

import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class CSSColor {
    private static final HashMap COLOR_MAP = new HashMap();
    private String value;
    private Color color;

    static {
        COLOR_MAP.put("maroon", "#800000");
        COLOR_MAP.put("red", "#ff0000");
        COLOR_MAP.put("orange", "#ffa500");
        COLOR_MAP.put("yellow", "#ffff00");
        COLOR_MAP.put("olive", "#808000");
        COLOR_MAP.put("purple", "#800080");
        COLOR_MAP.put("fuchsia", "#ff00ff");
        COLOR_MAP.put("white", "#ffffff");
        COLOR_MAP.put("lime", "#00ff00");
        COLOR_MAP.put("green", "#008000");
        COLOR_MAP.put("navy", "#000080");
        COLOR_MAP.put("blue", "#0000ff");
        COLOR_MAP.put("aqua", "#00ffff");
        COLOR_MAP.put("teal", "#008080");
        COLOR_MAP.put("black", "#000000");
        COLOR_MAP.put("silver", "#c0c0c0");
        COLOR_MAP.put("gray", "#808080");
    }

    public CSSColor(String val) {
        this.value = val;
        this.color = CSSColor.convertValue(this.value);
    }

    public static Color convertValue(String value) {
        Color color;
        String val1 = value.toLowerCase();
        if (val1.charAt(0) != '#') {
            val1 = (String)COLOR_MAP.get(val1);
        }
        if (val1 != null) {
            String hexVal = val1.substring(1).trim();
            try {
                int rgb = Integer.parseInt(hexVal, 16);
                color = new Color(rgb);
            }
            catch (NumberFormatException numberFormatException) {
                color = Color.BLACK;
            }
        } else {
            color = null;
        }
        return color;
    }

    public Color getValue() {
        return this.color;
    }

    public String toString() {
        return this.value;
    }

    public static boolean isValidColor(String val) {
        boolean ret = false;
        if (val.charAt(0) == '#') {
            ret = true;
        } else {
            Set colors = COLOR_MAP.keySet();
            Iterator i = colors.iterator();
            while (i.hasNext() && !ret) {
                String color = (String)i.next();
                if (!color.equalsIgnoreCase(val)) continue;
                ret = true;
            }
        }
        return ret;
    }
}

